
//****************************************************************************
//
// WIREWORKS PACKET CONVERTER
// Packet.h
//
// By: The White Salmon Group, Inc.
// Copyright 2006
// All rights reserved
//
//
//****************************************************************************

// TIMS Packet Header
#ifndef MY_TYPES_INCLUDED
#include "types.h"
#endif


// TIMS Packet
typedef union {
	struct {
		U8	to;
		U8	from;
		U16	ctrl;
		U16	status;
		U8	ref;
		U8	len;
		U8	data[256];
		};
	char buffer[264];
	} TIMS_packet;


// Function Codes
#define EXT_5V_ON				0x0010
#define EXT_5V_OFF				0x0011

#define SPI_DEVICE_CONFIG_RE	0x0020
#define SPI_DEVICE_CONFIG_WE	0x0021
#define SPI_DEVICE_ENABLE		0x0023
#define SPI_DATA_IO				0x0024
#define SPI_DEVICE_IO			0x0025

#define I2C_BUS_CONFIG_WE		0x0130
#define I2C_BUS_CONFIG_RE		0x0131
#define I2C_DEVICE_IO_A7R		0x0132
#define I2C_SCRIPT_IO			0x0134
#define I2C_FUNCTION_ERROR		0x013E

// Error responses - these defined by WireWorks and might be in a header somewhere else  
#define TIMS_TIMEOUTBODY		5244	// timeout occured in body of packet
#define TIMS_TIMEOUTDATA		5245	// timeout occured in data of packet
#define TIMS_TIMEOUTLRC			5344	// timeout occured on LRC receive
#define TIMS_TIMEOUT			5343	// miscellaneous timeout
#define TIMS_CHECKSUMERR		5678	// I made this one up.

// SPI CLOCK
// CLKRG0, CLKRG1, TVAR in the range of 1 thru 255
#define CLK_RANGE_HIGH			0x00	// 10.0Mhz/(1+TVAR) = 5.0Mhz thru 39khz
#define CLK_RANGE_MID			0x01	// 2.50Mhz/(1+TVAR) = 1.25Mhz thru 9.8khz
#define CLK_RANGE_LOW			0x02	// 625Khz/(1+TVAR)  = 312Khz thru 2.4khz
#define CLK_RANGE_10MHZ			0x03	// 10mhz fixed

#define RX_MIDDLE_OF_TX			0x00	// default   
#define RX_END_OF_TX			0x04

#define IDLE_LO_FALL_EDGE		0x00      
#define IDLE_LO_RISE_EDGE		0x08	// default
#define IDLE_HI_FALL_EDGE		0x10
#define IDLE_HI_RISE_EDGE		0x18

// Default settings
#define TVAR					19		// 4=1mhz, 39=125khz, default to 250khz
#define CLOCK_CONFIG	(CLK_RANGE_HIGH|RX_MIDDLE_OF_TX|IDLE_LO_RISE_EDGE)

// Function Prototypes
int TIMS_Open(FT_HANDLE* pHandle, int ver/* version, temporary */);
int TIMS_Close(void);

int TIMS_Ext5VOn(void);
int TIMS_Ext5VOff(void);

int TIMS_SPIConfigSet(U8 addr, U8 clock, U8 tvar);
int TIMS_SPIConfigGet(U8 addr, U8* clock, U8* tvar);
int TIMS_SPIDeviceEnable(U8 addr);
int TIMS_SPIDataIO(U8 buffer[], int* len);
int TIMS_SPIDeviceIO(U8 addr, U8 buffer[], int* len);
